/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.viewer.statistics;

import filenet.sim.toolkit.viewer.VWSIMAnimatorDataModel;
import filenet.sim.toolkit.viewer.VWSIMAnimatorMap;
import filenet.sim.toolkit.viewer.VWSIMAnimatorStep;
import filenet.sim.toolkit.viewer.VWSIMAnimatorWorkflow;
import filenet.sim.toolkit.viewer.statistics.images.VWSIMImageLoader;
import filenet.sim.toolkit.viewer.statistics.resources.VWSIMResource;
import filenet.vw.toolkit.runtime.VWDuration;
import filenet.vw.toolkit.utils.table.VWTableSorter;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class VWSIMStepStatTableModel
extends AbstractTableModel {
    public static final int STAT_STEP_FIRST_COLUMN_INDEX = 0;
    public static final int STAT_STEP_WORKFLOW_COL = 0;
    public static final int STAT_STEP_MAP_COL = 1;
    public static final int STAT_STEP_NAME_COL = 2;
    public static final int STAT_STEP_ACTIVE_COL = 3;
    public static final int STAT_STEP_COMPLETED_COL = 4;
    public static final int STAT_STEP_COST_COL = 5;
    public static final int STAT_STEP_AVERAGE_COST_COL = 6;
    public static final int STAT_STEP_OVERDUE_COL = 7;
    public static final int STAT_STEP_AVERAGE_PROCESSING_TIME = 8;
    public static final int STAT_STEP_MIN_PROCESSING_TIME = 9;
    public static final int STAT_STEP_MAX_PROCESSING_TIME = 10;
    public static final int STAT_STEP_AVERAGE_COMPLETION_TIME = 11;
    public static final int STAT_STEP_MIN_COMPLETION_TIME = 12;
    public static final int STAT_STEP_MAX_COMPLETION_TIME = 13;
    public static final int STAT_STEP_AVERAGE_WAIT_TIME = 14;
    public static final int STAT_STEP_MIN_WAIT_TIME = 15;
    public static final int STAT_STEP_MAX_WAIT_TIME = 16;
    public static final int STAT_STEP_LAST_COLUMN_INDEX = 16;
    protected VWSIMAnimatorDataModel m_animatorDataModel = null;
    protected ScenarioDataWrapper m_dataWrapper = null;
    private Vector m_columnNames = new Vector();
    private ImageIcon m_collapseIcon = VWSIMImageLoader.createImageIcon("collapse.gif");
    private ImageIcon m_expandIcon = VWSIMImageLoader.createImageIcon("expand.gif");
    VWTableSorter m_sorter = null;

    public static String _get_FILE_DATE() {
        return "$Date:   04 Mar 2005 16:47:40  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.4  $";
    }

    public VWSIMStepStatTableModel(VWSIMAnimatorDataModel animatorDataModel) {
        this.createTableSorter();
        this.m_animatorDataModel = animatorDataModel;
        this.initColumnNames();
    }

    VWSIMAnimatorDataModel getDataModel() {
        return this.m_animatorDataModel;
    }

    private void createTableSorter() {
        this.m_sorter = new VWTableSorter(this){

            public void tableChanged(TableModelEvent e) {
                int col = e.getColumn();
                if (e.getType() == 0 && col != 2 && col != -1) {
                    this.fireTableChanged(e);
                } else {
                    super.tableChanged(e);
                    this.sortByColumn(2);
                }
            }
        };
    }

    void initData() {
        if (this.m_animatorDataModel != null) {
            this.m_dataWrapper = new ScenarioDataWrapper();
        }
        this.fireTableDataChanged();
    }

    protected Vector getWorkflows() {
        if (this.m_animatorDataModel != null) {
            return this.m_animatorDataModel.getWorkflows();
        }
        return null;
    }

    protected Object internalGetValueAt(int row) {
        if (this.m_dataWrapper != null) {
            return this.m_dataWrapper.getValueAt(row);
        }
        return null;
    }

    public Object getValueAt(int row) {
        Object obj = this.internalGetValueAt(row);
        if (obj != null && obj instanceof DataWrapper) {
            return ((DataWrapper)obj).getData();
        }
        return null;
    }

    public Object getValueAt(int row, int col) {
        if (row < 0 || row >= this.getRowCount()) {
            return null;
        }
        WorkflowDataWrapper workflow = null;
        MapDataWrapper map = null;
        StepDataWrapper step = null;
        boolean bShowWorkflowName = false;
        boolean bShowMapName = false;
        boolean bExpandWorkflow = false;
        boolean bExpandMap = false;
        boolean bWorkflowRow = false;
        boolean bMapRow = false;
        boolean bStepRow = false;
        Object obj = this.internalGetValueAt(row);
        if (obj != null) {
            if (obj instanceof WorkflowDataWrapper) {
                workflow = (WorkflowDataWrapper)obj;
                bShowWorkflowName = true;
                bWorkflowRow = true;
            } else if (obj instanceof MapDataWrapper) {
                map = (MapDataWrapper)obj;
                workflow = map.getWorkflow();
                bShowMapName = true;
                if (workflow.getValueAt(0) == map) {
                    bShowWorkflowName = true;
                }
                bExpandWorkflow = true;
                bMapRow = true;
            } else if (obj instanceof StepDataWrapper) {
                step = (StepDataWrapper)obj;
                map = step.getMap();
                workflow = map.getWorkflow();
                if (map.getValueAt(0) == step) {
                    bShowMapName = true;
                }
                if (workflow.getValueAt(0) == step) {
                    bShowWorkflowName = true;
                }
                bExpandWorkflow = true;
                bExpandMap = true;
                bStepRow = true;
            }
        }
        if (obj != null) {
            switch (col) {
                case 0: {
                    if (bShowWorkflowName && workflow != null) {
                        JLabel workflowName = new JLabel(workflow.getWorkflow().getName());
                        if (bExpandWorkflow) {
                            workflowName.setIcon(this.m_collapseIcon);
                        } else {
                            workflowName.setIcon(this.m_expandIcon);
                        }
                        return workflowName;
                    }
                    return null;
                }
                case 1: {
                    if (bShowMapName && map != null) {
                        JLabel mapName = new JLabel(map.getMap().getMapName());
                        if (bExpandMap) {
                            mapName.setIcon(this.m_collapseIcon);
                        } else {
                            mapName.setIcon(this.m_expandIcon);
                        }
                        return mapName;
                    }
                    return null;
                }
                case 2: {
                    if (step != null && step.getStep() != null) {
                        return step.getStep().getStepName();
                    }
                    return null;
                }
                case 3: {
                    if (bWorkflowRow) {
                        VWSIMAnimatorWorkflow wf = workflow.getWorkflow();
                        if (wf != null) {
                            return new Integer(wf.getActiveCount());
                        }
                    } else if (bMapRow) {
                        VWSIMAnimatorMap mp = map.getMap();
                        if (mp != null) {
                            return new Integer(mp.getActiveCount());
                        }
                    } else if (step != null && step.getStep() != null) {
                        return new Integer(step.getStep().getActiveCount());
                    }
                    return null;
                }
                case 4: {
                    if (bWorkflowRow) {
                        VWSIMAnimatorWorkflow wf = workflow.getWorkflow();
                        if (wf != null) {
                            return new Integer(wf.getCompletedCount());
                        }
                    } else if (bMapRow) {
                        VWSIMAnimatorMap mp = map.getMap();
                        if (mp != null) {
                            return new Integer(mp.getCompletedCount());
                        }
                    } else if (step != null && step.getStep() != null) {
                        return new Integer(step.getStep().getCompletedCount());
                    }
                    return null;
                }
                case 7: {
                    if (step != null && step.getStep() != null) {
                        return new Integer(step.getStep().getOverdueCount());
                    }
                    return null;
                }
                case 5: {
                    if (step != null && step.getStep() != null) {
                        return new Double(step.getStep().getCost());
                    }
                    return null;
                }
                case 6: {
                    if (step != null && step.getStep() != null) {
                        return new Double(step.getStep().getAverageCost());
                    }
                    return null;
                }
                case 15: {
                    long time;
                    if (step != null && step.getStep() != null && (time = step.getStep().getMinWaitTime()) != 0L) {
                        return new VWDuration(time).toString();
                    }
                    return null;
                }
                case 16: {
                    long time;
                    if (step != null && step.getStep() != null && (time = step.getStep().getMaxWaitTime()) != 0L) {
                        return new VWDuration(time).toString();
                    }
                    return null;
                }
                case 14: {
                    long time;
                    if (step != null && step.getStep() != null && (time = step.getStep().getAverageWaitTime()) != 0L) {
                        return new VWDuration(time).toString();
                    }
                    return null;
                }
                case 9: {
                    long time;
                    if (step != null && step.getStep() != null && (time = step.getStep().getMinProcessingTime()) != 0L) {
                        return new VWDuration(time).toString();
                    }
                    return null;
                }
                case 10: {
                    long time;
                    if (step != null && step.getStep() != null && (time = step.getStep().getMaxProcessingTime()) != 0L) {
                        return new VWDuration(time).toString();
                    }
                    return null;
                }
                case 8: {
                    long time;
                    if (step != null && step.getStep() != null && (time = step.getStep().getAverageProcessingTime()) != 0L) {
                        return new VWDuration(time).toString();
                    }
                    return null;
                }
                case 12: {
                    long time;
                    if (step != null && step.getStep() != null && (time = step.getStep().getMinCompletionTime()) != 0L) {
                        return new VWDuration(time).toString();
                    }
                    return null;
                }
                case 13: {
                    long time;
                    if (step != null && step.getStep() != null && (time = step.getStep().getMaxCompletionTime()) != 0L) {
                        return new VWDuration(time).toString();
                    }
                    return null;
                }
                case 11: {
                    long time;
                    if (step != null && step.getStep() != null && (time = step.getStep().getAverageCompletionWaitTime()) != 0L) {
                        return new VWDuration(time).toString();
                    }
                    return null;
                }
            }
        }
        return null;
    }

    protected void initColumnNames() {
        this.m_columnNames.addElement(VWSIMResource.s_workflow_col);
        this.m_columnNames.addElement(VWSIMResource.s_map_col);
        this.m_columnNames.addElement(VWSIMResource.s_step_col);
        this.m_columnNames.addElement(VWSIMResource.s_active_col);
        this.m_columnNames.addElement(VWSIMResource.s_completed_col);
        this.m_columnNames.addElement(VWSIMResource.s_cost_col);
        this.m_columnNames.addElement(VWSIMResource.s_average_cost_col);
        this.m_columnNames.addElement(VWSIMResource.s_overdue_col);
        this.m_columnNames.addElement(VWSIMResource.s_average_processing_col);
        this.m_columnNames.addElement(VWSIMResource.s_min_processing_col);
        this.m_columnNames.addElement(VWSIMResource.s_max_processing_col);
        this.m_columnNames.addElement(VWSIMResource.s_average_completion_col);
        this.m_columnNames.addElement(VWSIMResource.s_min_completion_col);
        this.m_columnNames.addElement(VWSIMResource.s_max_completion_col);
        this.m_columnNames.addElement(VWSIMResource.s_average_wait_col);
        this.m_columnNames.addElement(VWSIMResource.s_min_wait_col);
        this.m_columnNames.addElement(VWSIMResource.s_max_wait_col);
    }

    public Class getColumnClass(int col) {
        switch (col) {
            case 0: 
            case 1: {
                return JLabel.class;
            }
            case 2: {
                return String.class;
            }
            case 3: 
            case 4: 
            case 7: {
                return Integer.class;
            }
            case 5: 
            case 6: {
                return Double.class;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                return String.class;
            }
        }
        return String.class;
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public int getRowCount() {
        if (this.m_dataWrapper != null) {
            return this.m_dataWrapper.getRowCount();
        }
        return 0;
    }

    public VWSIMAnimatorWorkflow getWorkflow(int row) {
        Object obj;
        Vector workflows = this.getWorkflows();
        VWSIMAnimatorWorkflow workflow = null;
        if (workflows != null && row < workflows.size() && (obj = workflows.elementAt(row)) != null && obj instanceof VWSIMAnimatorWorkflow) {
            workflow = (VWSIMAnimatorWorkflow)obj;
        }
        workflows = null;
        return workflow;
    }

    public int getColumnCount() {
        return this.m_columnNames.size();
    }

    public String getColumnName(int col) {
        if (col < this.getColumnCount()) {
            return (String)this.m_columnNames.elementAt(col);
        }
        return null;
    }

    public VWTableSorter getTableSorter() {
        return this.m_sorter;
    }

    protected void cellClicked(int row, int col) {
        boolean bBlankCell;
        boolean bl = bBlankCell = this.getValueAt(row, col) == null;
        if (bBlankCell) {
            return;
        }
        boolean bChanged = false;
        Object obj = this.internalGetValueAt(row);
        if (obj != null) {
            if (obj instanceof StepDataWrapper) {
                StepDataWrapper step = (StepDataWrapper)obj;
                if (col == 0) {
                    obj = step.getWorkflow();
                } else if (col == 1) {
                    obj = step.getMap();
                }
            }
            if (obj instanceof MapDataWrapper) {
                if (col == 0) {
                    obj = ((MapDataWrapper)obj).getWorkflow();
                } else if (col == 1 && col == 1) {
                    MapDataWrapper map;
                    map.setExpanded(!(map = (MapDataWrapper)obj).isExpanded());
                    bChanged = true;
                }
            }
            if (obj instanceof WorkflowDataWrapper && col == 0) {
                WorkflowDataWrapper wf;
                wf.setExpanded(!(wf = (WorkflowDataWrapper)obj).isExpanded());
                bChanged = true;
            }
        }
        if (bChanged) {
            this.fireTableDataChanged();
        }
    }

    void releaseResources() {
        this.m_animatorDataModel = null;
        if (this.m_dataWrapper != null) {
            this.m_dataWrapper.releaseResources();
        }
        this.m_dataWrapper = null;
        if (this.m_columnNames != null) {
            this.m_columnNames.removeAllElements();
            this.m_columnNames = null;
        }
        this.m_collapseIcon = null;
        this.m_expandIcon = null;
        this.m_sorter = null;
    }

    private class StepDataWrapper
    extends DataWrapper {
        MapDataWrapper m_map;
        VWSIMAnimatorStep m_step;

        StepDataWrapper(MapDataWrapper map, VWSIMAnimatorStep step) {
            this.m_map = null;
            this.m_step = null;
            this.m_map = map;
            this.m_step = step;
        }

        VWSIMAnimatorStep getStep() {
            return this.m_step;
        }

        MapDataWrapper getMap() {
            return this.m_map;
        }

        Object getData() {
            return this.m_step;
        }

        WorkflowDataWrapper getWorkflow() {
            if (this.m_map != null) {
                return this.m_map.getWorkflow();
            }
            return null;
        }

        void releaseResources() {
            this.m_map = null;
            this.m_step = null;
        }
    }

    private class MapDataWrapper
    extends DataWrapper {
        VWSIMAnimatorMap m_map;
        WorkflowDataWrapper m_workflow;
        Vector m_steps;
        boolean m_bExpanded;

        MapDataWrapper(WorkflowDataWrapper workflow, VWSIMAnimatorMap map) {
            Vector steps;
            this.m_map = null;
            this.m_workflow = null;
            this.m_steps = new Vector();
            this.m_bExpanded = false;
            this.m_workflow = workflow;
            this.m_map = map;
            if (this.m_map != null && (steps = this.m_map.getSteps()) != null) {
                Object obj = null;
                for (int i = 0; i < steps.size(); ++i) {
                    obj = steps.elementAt(i);
                    if (obj == null || !(obj instanceof VWSIMAnimatorStep)) continue;
                    this.m_steps.add(new StepDataWrapper(this, obj));
                }
            }
        }

        VWSIMAnimatorMap getMap() {
            return this.m_map;
        }

        Object getData() {
            return this.m_map;
        }

        WorkflowDataWrapper getWorkflow() {
            return this.m_workflow;
        }

        boolean isExpanded() {
            return this.m_bExpanded;
        }

        void setExpanded(boolean bExpanded) {
            this.m_bExpanded = bExpanded;
        }

        int getRowCount() {
            int count = 0;
            count = !this.m_bExpanded ? 1 : this.m_steps.size();
            if (count == 0) {
                count = 1;
            }
            return count;
        }

        Object getValueAt(int index) {
            if (index >= 0 && index < this.getRowCount()) {
                if (!this.m_bExpanded) {
                    if (index == 0) {
                        return this;
                    }
                } else if (index < this.m_steps.size()) {
                    return this.m_steps.elementAt(index);
                }
            }
            return null;
        }

        void releaseResources() {
            this.m_map = null;
            this.m_workflow = null;
            if (this.m_steps != null) {
                Object obj = null;
                for (int i = 0; i < this.m_steps.size(); ++i) {
                    obj = this.m_steps.elementAt(i);
                    if (obj == null || !(obj instanceof StepDataWrapper)) continue;
                    ((StepDataWrapper)obj).releaseResources();
                }
                this.m_steps.removeAllElements();
                this.m_steps = null;
            }
        }
    }

    private class WorkflowDataWrapper
    extends DataWrapper {
        VWSIMAnimatorWorkflow m_workflow;
        Vector m_maps;
        boolean m_bExpanded;

        WorkflowDataWrapper(VWSIMAnimatorWorkflow workflow) {
            Vector maps;
            this.m_workflow = null;
            this.m_maps = new Vector();
            this.m_bExpanded = true;
            this.m_workflow = workflow;
            if (this.m_workflow != null && (maps = this.m_workflow.getMaps()) != null) {
                Object obj = null;
                for (int i = 0; i < maps.size(); ++i) {
                    obj = maps.elementAt(i);
                    if (obj == null || !(obj instanceof VWSIMAnimatorMap)) continue;
                    this.m_maps.add(new MapDataWrapper(this, obj));
                }
            }
        }

        VWSIMAnimatorWorkflow getWorkflow() {
            return this.m_workflow;
        }

        Object getData() {
            return this.m_workflow;
        }

        boolean isExpanded() {
            return this.m_bExpanded;
        }

        void setExpanded(boolean bExpanded) {
            this.m_bExpanded = bExpanded;
        }

        int getRowCount() {
            int count = 0;
            if (!this.m_bExpanded) {
                count = 1;
            } else {
                Object obj = null;
                for (int i = 0; i < this.m_maps.size(); ++i) {
                    obj = this.m_maps.elementAt(i);
                    if (obj == null || !(obj instanceof MapDataWrapper)) continue;
                    count += ((MapDataWrapper)obj).getRowCount();
                }
            }
            if (count == 0) {
                count = 1;
            }
            return count;
        }

        Object getValueAt(int index) {
            if (index >= 0 && index < this.getRowCount()) {
                if (!this.m_bExpanded) {
                    if (index == 0) {
                        return this;
                    }
                } else {
                    int count = 0;
                    Object obj = null;
                    for (int i = 0; i < this.m_maps.size(); ++i) {
                        obj = this.m_maps.elementAt(i);
                        if (obj == null || !(obj instanceof MapDataWrapper)) continue;
                        count = ((MapDataWrapper)obj).getRowCount();
                        if (index < count) {
                            return ((MapDataWrapper)obj).getValueAt(index);
                        }
                        index -= count;
                    }
                }
            }
            return null;
        }

        void releaseResources() {
            this.m_workflow = null;
            if (this.m_maps != null) {
                Object obj = null;
                for (int i = 0; i < this.m_maps.size(); ++i) {
                    obj = this.m_maps.elementAt(i);
                    if (obj == null || !(obj instanceof MapDataWrapper)) continue;
                    ((MapDataWrapper)obj).releaseResources();
                }
                this.m_maps.removeAllElements();
                this.m_maps = null;
            }
        }
    }

    private class ScenarioDataWrapper
    extends DataWrapper {
        Vector m_workflows;

        ScenarioDataWrapper() {
            this.m_workflows = new Vector();
            if (VWSIMStepStatTableModel.this.getDataModel() != null) {
                Vector workflows = VWSIMStepStatTableModel.this.getDataModel().getWorkflows();
                if (workflows != null) {
                    Object obj = null;
                    for (int i = 0; i < workflows.size(); ++i) {
                        obj = workflows.elementAt(i);
                        if (obj == null || !(obj instanceof VWSIMAnimatorWorkflow)) continue;
                        this.m_workflows.add(new WorkflowDataWrapper(obj));
                    }
                }
                Object var2_2 = null;
            }
        }

        int getRowCount() {
            int count = 0;
            Object obj = null;
            for (int i = 0; i < this.m_workflows.size(); ++i) {
                obj = this.m_workflows.elementAt(i);
                if (obj == null || !(obj instanceof WorkflowDataWrapper)) continue;
                count += ((WorkflowDataWrapper)obj).getRowCount();
            }
            if (count == 0) {
                count = 1;
            }
            return count;
        }

        Object getValueAt(int index) {
            if (index >= 0 && index < this.getRowCount()) {
                int count = 0;
                for (int i = 0; i < this.m_workflows.size(); ++i) {
                    Object obj = this.m_workflows.elementAt(i);
                    if (obj == null || !(obj instanceof WorkflowDataWrapper)) continue;
                    count = ((WorkflowDataWrapper)obj).getRowCount();
                    if (index < count) {
                        return ((WorkflowDataWrapper)obj).getValueAt(index);
                    }
                    index -= count;
                }
            }
            return null;
        }

        Object getData() {
            return VWSIMStepStatTableModel.this.getDataModel();
        }

        void releaseResources() {
            if (this.m_workflows != null) {
                Object obj = null;
                for (int i = 0; i < this.m_workflows.size(); ++i) {
                    obj = this.m_workflows.elementAt(i);
                    if (obj == null || !(obj instanceof WorkflowDataWrapper)) continue;
                    ((WorkflowDataWrapper)obj).releaseResources();
                }
                this.m_workflows.removeAllElements();
                this.m_workflows = null;
            }
        }
    }

    private abstract class DataWrapper {
        private DataWrapper() {
        }

        abstract Object getData();
    }
}

